<?php
    class Types {

        #[ParameterAttribute(direction: ParameterDirection::InputOutput)]
        public int $int = 0;

        #[ParameterAttribute(direction: ParameterDirection::InputOutput)]
        public ?int $nullableInt = null;

        #[ParameterAttribute(direction: ParameterDirection::InputOutput)]
        public null | int $nullOrInt = null;

        #[ParameterAttribute(direction: ParameterDirection::InputOutput)]
        public string $string = "";

        #[ParameterAttribute(direction: ParameterDirection::InputOutput)]
        public ?string $nullableString = "";

        #[ParameterAttribute(direction: ParameterDirection::InputOutput)]
        public null | string $nullOrString = "";

        #[ParameterAttribute(direction: ParameterDirection::InputOutput)]
        public bool $bool1 = false;

        #[ParameterAttribute(direction: ParameterDirection::InputOutput)]
        public bool $bool2 = true;

        #[ParameterAttribute(direction: ParameterDirection::InputOutput)]
        public ?bool $nullableBool = null;

        #[ParameterAttribute(direction: ParameterDirection::InputOutput)]
        public null | bool $nullOrBool = null;
    }
    
    include("../cxn.php");
    include("../../../lib/helper.php");
    include("../../../lib/standard.php");
    //$debug = true;
    Http::responseDefaultHeaders();

    if (Http::isActionRequest()) {

        echo "Types Example:\n\n";

        $myTypes = new Types();

        $myReflectionClass = new ReflectionClass(Types::class);

        echo "\nmyTypes: " . json_encode($myTypes) . "\n"; 

        echo "\nProperties:\n"; 

        foreach ($myReflectionClass->getProperties() as $myProperty) {
            echo $myProperty->name . ": " . $myProperty->getType() . " = " . $myTypes->{$myProperty->name}, ", " . $myProperty->getValue($myTypes) . "\n";
        }

        echo "\nCommand:\n";

        $myCmd = Command::fromModel("test.test_select", $myTypes);

        echo $myCmd->toString() . "\n";
    }
?>