<?php
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Headers: *");
    header("Access-Control-Allow-Methods: *");
    Include ("../cxn.php");
    Include ("../../../lib/helper.php");

    try {
        $mySession = authorize("sx.itemType", Permissions::Write, $cxn);
        
        $myModel = Http::fromUri('ItemType');
        $myModel->rid = $mySession->accountId;

        if ($debug) { echo json_encode($myModel); }

        $myResults = Command::fromModel("sx.itemType_save", $myModel)->execute($cxn);
        $myResult = array_values($myResults)[0][0];

        $myModel->id = $myResult["id"];
        $myModel->rv = $myResult["rv"];
        $myModel->dts = $myResult["dts"];

        echo json_encode($myModel);
    }
    catch(\Throwable | \Exception | \Error $ex) {
        Http::responseBadRequest($ex);
    }

    $cxn->close();
?>