<?php
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Headers: *");
    header("Access-Control-Allow-Methods: *");
    Include ("../cxn.php");
    Include ("../../../lib/helper.php");

    try {
        $mySession = authorize("sx.itemType", Permissions::Write, $cxn);
        
        $myModel = new ItemType();

        $myModel->id = array_getValue($_GET, "id");
        $myModel->rv = array_getValue($_GET, "rv");
        $myModel->rid = $mySession->accountId;

        $myModel->state = (bool)array_getValue($_GET, "state", true);
        $myModel->sort = array_getValue($_GET, "sort", 10);

        $myModel->code = array_getValue($_GET, "code");
        $myModel->name = array_getValue($_GET, "name");

        if ($debug) { echo json_encode($myModel); }

        $myCommand = new Command("sx.itemType_save");

        $myCommand->parameters->add(new Parameter("id", $myModel->id, ParameterDirection::InputOutput));
        $myCommand->parameters->add(new Parameter("rv", $myModel->rv, ParameterDirection::InputOutput));
        $myCommand->parameters->add(new Parameter("rid", $myModel->rid));
        $myCommand->parameters->add(new Parameter("dts", $myModel->dts, ParameterDirection::InputOutput));
        $myCommand->parameters->add(new Parameter("state", $myModel->state));
        $myCommand->parameters->add(new Parameter("sort", $myModel->sort));
        $myCommand->parameters->add(new Parameter("code", array_getValue($_GET, "code")));
        $myCommand->parameters->add(new Parameter("name", array_getValue($_GET, "name")));

        $myResults = $myCommand->execute($cxn);
        $myResult = array_values($myResults)[0][0];

        $myModel->id = $myResult["id"];
        $myModel->rv = $myResult["rv"];
        $myModel->dts = $myResult["dts"];

        echo json_encode($myModel);

        $cxn->close();   
    }
    catch(\Throwable | \Exception | \Error $ex) {

        Http::responseBadRequest($ex);

        $cxn->close();
    }

    class ItemType {
        
        public ?int $id;
        public ?string $rv;
        public ?int $rid;
        public ?string $dts;

        public ?int $state = 1;
        public ?int $sort = 10;

        public ?string $code;
        public ?string $name;
    }
?>