<?php
    class MyClassWithDate {

        public null | DateTime $date = null;
    }

    Include("../cxn.php");
    Include("../../../lib/helper.php");
    Include("../../../lib/standard.php");
//$debug = true;
    Http::responseDefaultHeaders();

    $_REQUEST["date"] = "2000-01-01";

    echo "<br>request date: " . $_REQUEST["date"] . "<br>";

    echo "<br>new date: " . date("Y-m-d H:i:s,u") . "<br>"; 

    echo "<br>" . gmdate("Y-m-d H:i:s.u") . "<br>";

    echo "<br>rfc3339: " . DATE_RFC3339_EXTENDED . "<br>";

    echo "<br>gmdate: " . gmdate(DATE_RFC3339_EXTENDED) . "<br>";

    echo "<br>microtime: " . microtime() . "<br>";

    $myJsonDate = '2022-12-31T23:01:02.345678Z';

    $myUtcDate = new DateTime($myJsonDate, new DateTimeZone('UTC'));
    $myUtcString = $myUtcDate->format('Y-m-d');

    $myLocalDate = $myUtcDate->setTimeZone(new DateTimeZone(date_default_timezone_get()));

    //$myLocalDate = new DateTime($myJsonDate, new DateTimeZone(date_default_timezone_get()));
    $myLocalString = $myLocalDate->format('Y-m-d');

    echo "<br>type of date: " . gettype($myLocalDate) . ", typeof date string: " . gettype($myLocalString) . "<br>";

    echo "<br>json-date: $myJsonDate, utc-date: $myUtcString, local-date: $myLocalString<br>";

    echo "<br>" . date_toLocalDateTimeString($myJsonDate, 'Y-m-d') . "<br>";
    echo "<br>" . date_toLocalDateTimeString($myJsonDate) . "<br>";

    echo "<br>null date: " . date_toLocalDateTime(null) . "<br>";
    echo "<br>null date string: " . date_toLocalDateTimeString(null) . "<br>";

    $myClassName = MyClassWithDate::class;

    $myInstance = new $myClassName();

    $myReflectionClass = new ReflectionClass("MyClassWithDate");

    $myProperty = $myReflectionClass->getProperty("date");

    echo "<br>date: " . $myProperty->getType() . "<br>";

    $myInstance->date =  new DateTime(null, new DateTimeZone("UTC"));

    if ($myReflectionClass->hasProperty("doesNotExist")) {
        $myProperty = $myReflectionClass->hasProperty("doesNotExist");
        echo "<br>" . gettext($myProperty) . "<br>";
    }

    /* if (Http::isActionRequest()) {
        if (Http::isUriRequest()) { Http::responseOk(Http::fromUri(AccountDocument::class)); }
        else if (Http::isFormRequest()) { Http::responseOk(Http::fromForm(AccountDocument::class)); }
        else { http::responseOk(Http::fromJson(AccountDocument::class)); }
    } */
?>