<?php

class Account {
    #[ParameterAttribute(direction: ParameterDirection::InputOutput)]
	public ?int $id = null;

	#[ParameterAttribute(direction: ParameterDirection::InputOutput)]
	public ?string $rv = null;

	#[ParameterAttribute]
	public ?int $rid = null;

	#[ParameterAttribute(direction: ParameterDirection::InputOutput)]
	public ?string $dts = null;

	#[ParameterAttribute]
	public ?int $state = 1;

	#[ParameterAttribute]
	public ?int $type = 0;

	#[ParameterAttribute]
	public ?string $code = null;

	#[ParameterAttribute]
	public ?string $firstName = null;

	#[ParameterAttribute]
	public ?string $lastName = null;

	#[ParameterAttribute]
	public ?string $image = null;

	#[ParameterAttribute]
	public ?string $description = null;

	#[ParameterAttribute]
	public ?int $personType = null;

	#[ParameterAttribute]
	public ?string $oib = null;

	#[ParameterAttribute]
	public ?string $email = null;

	#[ParameterAttribute]
	public ?string $gsm = null;

	#[ParameterAttribute]
	public ?string $phone = null;

	#[ParameterAttribute]
	public ?string $fax = null;

	#[ParameterAttribute]
	public ?int $cityId = null;

	#[ParameterAttribute]
	public ?string $address = null;

	#[ParameterAttribute]
	public ?string $cityIdDelivery = null;

	#[ParameterAttribute]
	public ?string $addressDelivery = null;

	
	#[ParameterAttribute]
	public ?int $currencyId = null;

	#[ParameterAttribute]
	public ?string $cultureCode = null;

	#[ParameterAttribute]
	public ?string $colorSchemeCode = null;

	#[ParameterAttribute]
	public ?int $roleId = null;

	#[ParameterAttribute]
	public ?bool $passwordChange = null;

	#[ParameterAttribute]
	public ?string $passwordOld = null;

	#[ParameterAttribute]
	public ?string $passwordNew = null;

	#[ParameterAttribute]
	public ?string $passwordRepeat = null;


	public ?string $username = null;

	public ?string $name = null;
}

class AccountDocument extends Account {

	public Array $groups = [];

	public Array $members = [];
}

class SelectByEmail {
	
	#[ParameterAttribute]
	public ?string $email = null;

	#[ParameterAttribute]
	public ?string $token = null;

	#[ParameterAttribute]
	public ?string $passwordNew = null;

	#[ParameterAttribute]
	public ?string $passwordRepeat = null;
}
?>