<?php
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Headers: *");
    header("Access-Control-Allow-Methods: *");
    header("Access-Control-Allow-Credentials: true");
    Include ("../cxn.php");
    Include ("../../../lib/helper.php");
    Include ("../../../lib/standard.php");

    try {
        if ($_SERVER['REQUEST_METHOD'] != 'OPTIONS') {
            $mySession = authorize("sx.itemType", Permissions::Read, $cxn);

            $myModel = Http::fromUri(StandardUniqueParameters::class);
            $myModel->rid = $mySession->accountId;

            foreach(Command::fromModel("sx.itemType_unique", $myModel)->execute($cxn) as $myResult) {
                echo json_encode($myResult);
            }
        }
    }
    catch(\Throwable | \Exception | \Error $ex) {
        Http::responseBadRequest($ex);
    }

    $cxn->close();
?>