<?php
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Headers: *");
    header("Access-Control-Allow-Methods: *");
    Include ("../cxn.php");
    Include ("../../../lib/helper.php");
    Include ("../../../lib/standard.php");
    //$debug = true;
    try {
        if ($_SERVER["REQUEST_METHOD"] !== "OPTIONS") {
            $mySession = authorize("itemType", Permissions::Read, $cxn);

            $myModel = Http::fromUri(StandardSelectParameters::class);
            $myModel->rid = $mySession->accountId;

            foreach(Command::fromModel("sx.itemType_select", $myModel)->execute($cxn) as $myResult) {
                echo json_encode($myResult);
            }
        }
    }
    catch(\Throwable | \Exception | \Error $ex) {
        Http::responseBadRequest($ex);
    }

    $cxn->close();
?>