<?php
    Include ("../cxn.php");
    Include ("../../../lib/helper.php");
    Include ("../../../lib/standard.php");

    try {
        $mySession = authorize("sx.itemType", Permissions::Read, $cxn);

        $myModel = Http::fromUri(StandardUniqueParameters::class);
        $myModel->rid = $mySession->accountId;

        foreach(Command::fromModel("sx.itemType_document", $myModel)->execute($cxn) as $myResult) {
            echo json_encode($myResult);
        }
    }
    catch(\Throwable | \Exception | \Error $ex) {
        Http::responseBadRequest($ex);
    }

    $cxn->close();
?>