<?php
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Headers: *");
    header("Access-Control-Allow-Methods: POST, DELETE");
    Include ("../cxn.php");
    Include ("../../../lib/helper.php");
    Include ("../../../lib/standard.php");
    //$debug = true;
    try {
        if ($_SERVER['REQUEST_METHOD'] != 'OPTIONS') {
            $mySession = authorize("sx.itemType", Permissions::Delete, $cxn);

            $myModel = Http::fromBody(StandardDeleteParameters::class);
            $myModel->rid = $mySession->accountId;

            if ($debug) { echo json_encode($myModel); }

            $myResults = Command::fromModel("sx.itemType_delete", $myModel)->execute($cxn);

            if ($debug) { var_dump($myResults); echo "<br />"; }

            $myModel->rv = $myResults[0][0]["rv"];
            $myModel->dts = $myResults[0][0]["dts"];

            echo json_encode($myModel);
        }
    }
    catch(\Throwable | \Exception | \Error $ex) {
        Http::responseBadRequest($ex);
    }

    $cxn->close();
?>