<?php
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Headers: Accept, Authorization, Content-Type");
    header("Access-Control-Allow-Methods: POST");
    Include("../cxn.php");
    Include("../../../lib/helper.php");
    Include ("./model.php");
//$debug = true;
    try
    {
        if ($_SERVER["REQUEST_METHOD"] != "OPTIONS") {
            $mySession = authorize("sx.item", Permissions::Write, $cxn);
            
            $myModel = Http::fromBody(ItemType::class);
            $myModel->rid = $mySession->accountId;

            if ($debug) { echo json_encode($myModel); }

            $myResults = Command::fromModel("sx.item_save", $myModel)->execute($cxn);
            $myResult = array_values($myResults)[0][0];

            $myModel->id = $myResult["id"];
            $myModel->rv = $myResult["rv"];
            $myModel->dts = $myResult["dts"];

            echo json_encode($myModel);
        }
    }
    catch (\Throwable | \Exception | \Error $ex) {
        Http::responseBadRequest($ex);
    }

    $cxn->close();
?>