<?php
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Headers: Accept, Authorization, Content-Type");
    header("Access-Control-Allow-Methods: GET");
    Include("../cxn.php");
    Include("../../../lib/helper.php");
    Include("../../../lib/standard.php");

    try
    {
        if ($_SERVER["REQUEST_METHOD"] != "OPTIONS") {
            $mySession = authorize("sx.item", Permissions::Read, $cxn);

            $myModel = Http::fromUri(StandardUniqueParameters::class);
            $myModel->rid = $mySession->accountId;

            foreach(Command::fromModel("sx.item_document", $myModel)->execute($cxn) as $myResult) {
                echo json_encode($myResult);
            }
        }
    }
    catch (\Throwable | \Exception | \Error $ex) {
        Http::responseBadRequest($ex);
    }

    $cxn->close();
?>