<?php
    Include ("../cxn.php");
    Include ("../../../lib/standard.php");
    Include ("../../../lib/helper.php");
$debug = false;
$cxn = null;

    try {

        Http::responseDefaultHeaders("GET");

        if (Http::isActionRequest()) {

            $cxn = Connection::open();

            $mySession = \Service\StandardData::authorize("sx.item", Permissions::Read, $cxn);

            $id = array_getValue($_GET, "id", 'null');
            $rid = $mySession->accountId;

            if ($debug) { echo "query: call sx.item_data($id, $rid, true)"; }

            $cxn->multi_query("call sx.item_data($id, $rid, true)");

            $cxn->multi_query(MYSQLI_ASSOC);

            $myTypes = [];

            $myResult = $cxn->store_result();

            while($myRow = $myResult->fetch_assoc()){
                $myTypes[] = $myRow;
            }

            $myResult->free_result();

            $myItems = [];
            $cxn -> next_result();
            $myResult = $cxn->store_result();

            while($myRow = $myResult->fetch_assoc()){
                $myRow["price"] = (float)$myRow["price"];
                $myRow["discount_p"] = (float)$myRow["discount_p"];
                $myRow["discount"] = (float)$myRow["discount"];
                $myRow["retail"] = (float)$myRow["retail"];

                $myItems[] = $myRow;
            }

            $myResult->free_result();

            $myComponents = [];
            $cxn -> next_result();
            $myResult = $cxn->store_result();

            while($myRow = $myResult->fetch_assoc()){
                $myRow["qty"] = (float)$myRow["qty"];

                $myComponents[] = $myRow;
            }

            $myResult->free_result();

            echo json_encode(array("types"=>$myTypes, "items"=>$myItems, "components"=>$myComponents));

            $cxn->close();
        }
    }
    catch(\Throwable | \Exception | \Error $ex) {

        Http::responseBadRequest($ex);

        $cxn->close();
    }
?>