<?php 

namespace Model {

    class SignInParameters {
        #[\ParameterAttribute]
        public ?string $username = null;
        
        #[\ParameterAttribute]
        public ?string $password = null;

        #[\ParameterAttribute]
        public ?string $userAgent = null;

        #[\ParameterAttribute]
        public ?string $remoteIp = null;

        #[\ParameterAttribute]
        public ?string $remoteHost = null;

        #[\ParameterAttribute]
        public ?string $remoteUser = null;

        #[\ParameterAttribute]
        public ?string $remotePort = null;

        #[\ParameterAttribute]
        public ?string $request = null;
    }

    class AuthorizationParameters {
        public ?string $schema = null;

        #[\ParameterAttribute]
        public ?string $token = null;

        #[\ParameterAttribute]
        public ?string $remoteUser = null;

        #[\ParameterAttribute]
        public ?string $remoteIp = null;

        #[\ParameterAttribute]
        public ?string $remoteHost = null;

        #[\ParameterAttribute]
        public ?string $userAgent = null;

        #[\ParameterAttribute]
        public ?string $context = null;

        #[\ParameterAttribute]
        public ?int $rowId = null;

        #[\ParameterAttribute]
        public ?int $permission = null;

        #[\ParameterAttribute]
        public ?bool $isLocalRequest = null;
    }

    class Session {
        #session
        public ?int $id = null;
        public ?string $token = null;
        public ?string $rv = null;
        public ?string $dts = null;

        #account
        public ?int $accountId = null;
        public ?string $accountRv = null;
        public ?string $accountDts = null;
        public ?string $code = null;
        public ?string $firstName = null;
        public ?string $lastName = null;
        public ?string $imagePath = null;
        public ?string $description = null;
        public ?int $personType = null;
        public ?string $oib = null;
        
        #contact
        public ?string $email = null;
        public ?string $phone = null;
        public ?string $gsm = null;
        public ?string $fax = null;
        public ?int $cityId = null;
        public ?string $cityCombo = null;
        public ?string $address = null;
        public ?int $cityIdDelivery = null;
        public ?string $cityDeliveryCombo = null;
        public ?string $addressDelivery = null;

        #other
        public ?int $currencyId = null;
        public ?string  $currency = null;
        public ?string  $culture = null;
        public ?string  $scheme = null;

        #permissions
        public ?string $role = null;
        public ?int $itemId = null;
        public ?string $itemCode = null;
        public ?string $itemName = null;
        public ?int $allow = null;
        public ?int $deny = null;
    }

    class StandardSelectParameters {
        #[\ParameterAttribute]
        public ?int $id = null;
        
        #[\ParameterAttribute]
        public ?int $rid = null;
        
        #[\ParameterAttribute]
        public ?int $state = 1;
    }

    class StandardUniqueParameters {
        #[\ParameterAttribute(direction: \ParameterDirection::InputOutput)]
        public ?int $id = null;

        #[\ParameterAttribute]
        public ?int $rid = null;
        
        #[\ParameterAttribute]
        public ?string $code = null;

        #[\ParameterAttribute]
        public ?string $name = null;
    }

    class StandardDeleteParameters {
        #[\ParameterAttribute]
        public ?int $id = null;

        #[\ParameterAttribute(direction: \ParameterDirection::InputOutput)]
        public ?string $rv = null;
        
        #[\ParameterAttribute]
        public ?int $rid = null;
        
        #[\ParameterAttribute(direction: \ParameterDirection::InputOutput)]
        public ?string $dts = null;
    }
}

namespace Service { 

    class StandardData {

        static function register(\Model\SignInParameters | \Model\AuthorizationParameters $context, \AccountDocument $accountParameters, &$cxn = null) : \Model\Session {

            if ($cxn == null) {

                $cxn = \Connection::open();

                $myReturn = StandardData::register($context, $accountParameters, $cxn);

                $cxn->close();

                return $myReturn;
            }
            else {

                if ($accountParameters->id) {

                    StandardData::save($context, "sx.account", $accountParameters, $cxn);

                    return StandardData::authorize($context, $cxn);
                }
                else {
                    $accountParameters->rid = 1;

                    \Command::fromModel("sx.account_save", $accountParameters)->execute($cxn);

                    return StandardData::signIn($context, $cxn);
                }
            }
        }

        static function signIn(\Model\SignInParameters $parameters, \mysqli &$cxn = null): \Model\Session {

            if ($cxn == null) {

                $cxn = \Connection::open();

                $myReturn = StandardData::signIn($parameters, $cxn);

                $cxn->close();

                return $myReturn;
            }
            else {
                $mySet = \Command::fromModel("sx.account_signin", $parameters)->execute($cxn);

                return $mySet && $mySet[0] && $mySet[0][0] ? \Http::fromJson(\Model\Session::class, json_encode($mySet[0][0])) : null;
            }
        }

        static function signOut(\Model\AuthorizationParameters $parameters, \mysqli &$cxn = null) {

            if ($cxn == null) {

                $cxn = \Connection::open();

                $myReturn = StandardData::signOut($parameters, $cxn);

                $cxn->close();
            }
            else {

                $myCmd = new \Command("sx.account_signout");// \Command::fromModel("sx.account_signout", $parameters)->execute($cxn);

                $myCmd->parameters->add(
                    new \Parameter("token", $parameters->token)
                );

                return $myCmd->execute($cxn);
            }
        }

        static function authorize(\Model\AuthorizationParameters $parameters, \mysqli &$cxn): \Model\Session {

            global $debug;

            if ($cxn == null) {

                $cxn = \Connection::open();

                $myReturn = StandardData::authorize($parameters, $permissions, $cxn);

                $cxn->close();

                return $myReturn;
            }
            else {

                $myData = \Command::fromModel("sx.session_authorize", $parameters)->execute($cxn);

                if ($myData && $myData[0] && $myData[0][0]) {
                    return \Http::fromJson(\Model\Session::class, json_encode($myData[0][0]));
                }
                else {
                    throw new \Exception("Not Authorized");
                }
            }
        }

        static function select(\Model\AuthorizationParameters $context, string $tableName, \Model\StandardSelectParameters $parameters, &$cxn = null, $resultCallback = null) : array {

            global $debug;

            if ($cxn == null) {

                $cxn = \Connection::open();

                $myReturn = StandardData::select($context, $tableName, $parameters, $cxn, $resultCallback);

                $cxn->close();

                return $myReturn;
            }
            else {

                $mySession = $context == null ? null : StandardData::authorize($context, $cxn);

                $parameters->rid = $mySession == null ? null : $mySession->accountId;
                
                return \Command::fromModel("${tableName}_select", $parameters)->execute($cxn, $resultCallback);
            }
        }

        static function unique(\Model\AuthorizationParameters $context, string $tableName, \Model\StandardUniqueParameters $parameters, \mysqli &$cxn = null, $resultCallback = null) : array {
        
            global $debug;

            if ($cxn == null) {

                $cxn = \Connection::open();

                $myReturn = StandardData::unique($context, $tableName, $parameters, $cxn, $resultCallback);

                $cxn->close();

                return $myReturn;
            }
            else {

                $mySession = $context == null ? null : StandardData::authorize($context, $cxn);

                $parameters->rid = $mySession == null ? null : $mySession->accountId;

                return \Command::fromModel($tableName . "_unique", $parameters)->execute($cxn, $resultCallback);
            }
        }

        static function document(\Model\AuthorizationParameters $context, string $tableName, \Model\StandardUniqueParameters $parameters, \mysqli &$cxn = null, $rowCallback = null) : array {
        
            global $debug;

            if ($cxn == null) {

                $cxn = \Connection::open();

                $myReturn = StandardData::document($context, $tableName, $parameters, $cxn, $rowCallback);

                $cxn->close();

                return $myReturn;
            }
            else {

                $mySession = $context == null ? null : StandardData::authorize($context, $cxn);

                $parameters->rid = $mySession == null ? null : $mySession->accountId;

                return \Command::fromModel("${tableName}_document", $parameters)->execute($cxn, $rowCallback);
            }
        }

        static function save(\Model\AuthorizationParameters $context, string $tableName, $parameters, \mysqli &$cxn = null, $resultCallback = null) : array {

            global $debug;

            if ($cxn == null) {

                $cxn = \Connection::open();

                $myReturn = StandardData::save($context, $tableName, $parameters, $cxn, $resultCallback);

                $cxn->close();

                return $myReturn;
            }
            else {

                $mySession = $context == null ? null : StandardData::authorize($context, $cxn);

                $parameters->rid = $mySession == null ? null : $mySession->accountId;

                $myCmd = \Command::fromModel("${tableName}_save", $parameters);

                $myReturn = $myCmd->execute($cxn, $resultCallback);

                for ($myIndex = 0; $myIndex < $myCmd->parameters->count(); $myIndex++) {
                    $myParameter = $myCmd->parameters->itemAt($myIndex);

                    if (($myParameter->direction & \ParameterDirection::Output) == \ParameterDirection::Output) {
                       $parameters->{$myParameter->name} = $myParameter->value;
                    }
                }

                return $myReturn;
            }
        }

        static function delete(\Model\AuthorizationParameters $context, string $tableName, \Model\StandardDeleteParameters $parameters, \mysqli &$cxn = null, $resultCallback = null) : array {

            global $debug;

            if ($cxn == null) {

                $cxn = \Connection::open();

                $myReturn = StandardData::delete($context, $tableName, $parameters, $cxn, $resultCallback);

                $cxn->close();

                return $myReturn;
            }
            else {

                $mySession = $context == null ? null : StandardData::authorize($context, $cxn);

                $parameters->rid = $mySession == null ? null : $mySession->accountId;

                $myParameters = new \Model\StandardUniqueParameters();

                $myParameters->id = $parameters->id;
                $myParameters->rid = $parameters->rid;

                $mySet = StandardData::document($context, $tableName, $myParameters, $cxn);

                if (count($mySet[0]) == 0) {
                    throw new \Exception("Data Does Not Exist");
                }
                else {
                    $myResult = \Command::fromModel("${tableName}_delete", $parameters)->execute($cxn, $resultCallback);

                    return $mySet;
                }
            }
        }
    }
}

namespace Api {

    class StandardData {

        static function get_authorizationParameters(string $context, int $permission): \Model\AuthorizationParameters {

            $myReturn = new \Model\AuthorizationParameters();

            $myAuthorizationHeader = apache_request_headers()["Authorization"];

            $mySplit = explode(" ", $myAuthorizationHeader);

            if (count($mySplit) > 0) { $myReturn->schema = $mySplit[0]; }
            if (count($mySplit) > 1) { $myReturn->token = $mySplit[1]; };

            $myReturn->userAgent = array_getValue($_SERVER, "HTTP_USER_AGENT");
            $myReturn->remoteIp = array_getValue($_SERVER, "HTTP_CLIENT_IP") ?? array_getValue($_SERVER, "HTTP_X_FORWARDED_FOR") ?? array_getValue($_SERVER, "REMOTE_ADDR"); 
            $myReturn->remoteHost = array_getValue($_SERVER, "REMOTE_HOST") ?? array_getValue($_SERVER, "HTTP_ORIGIN") ?? array_getValue($_SERVER, "HTTP_REFERER");
            $myReturn->remoteUser = array_getValue($_SERVER, "HTTP_REMOTE_USER");
            $myReturn->remotePort = array_getValue($_SERVER, "REMOTE_PORT");
            
            $myReturn->context = $context;
            $myReturn->permission = $permission;
            $myReturn->isLocalRequest = 0;

            return $myReturn;
        }

        static function get_signInModel(): \Model\SignInParameters {

            $myReturn;

            if (\Http::isUriRequest()) { $myReturn = \Http::fromUri(\Model\SignInParameters::class); }
            else if (\Http::isFormRequest()) { $myReturn = \Http::fromForm(\Model\SignInParameters::class); }
            else { $myReturn = \Http::fromJson(\Model\SignInParameters::class); }

            $myReturn->userAgent = array_getValue($_SERVER, "HTTP_USER_AGENT");
            $myReturn->remoteIp = array_getValue($_SERVER, "HTTP_CLIENT_IP") ?? array_getValue($_SERVER, "HTTP_X_FORWARDED_FOR") ?? array_getValue($_SERVER, "REMOTE_ADDR"); 
            $myReturn->remoteHost = array_getValue($_SERVER, "REMOTE_HOST") ?? array_getValue($_SERVER, "HTTP_ORIGIN") ?? array_getValue($_SERVER, "HTTP_REFERER");
            $myReturn->remoteUser = array_getValue($_SERVER, "HTTP_REMOTE_USER");
            $myReturn->remotePort = array_getValue($_SERVER, "REMOTE_PORT");
            $myReturn->request = json_encode(array(    
                "phpSelf" => array_getValue($_SERVER, 'PHP_SELF'),
                "gatewayInterface" => array_getValue($_SERVER, 'GATEWAY_INTERFACE'),
                "serverAddress" => array_getValue($_SERVER, 'SERVER_ADDR'),
                "serverName" => array_getValue($_SERVER, 'SERVER_NAME'),
                "serverSoftware" => array_getValue($_SERVER, 'SERVER_SOFTWARE'),
                "serverProtocol" => array_getValue($_SERVER, 'SERVER_PROTOCOL'),
                "requestMethod" => array_getValue($_SERVER, 'REQUEST_METHOD'),
                "requestTime" => array_getValue($_SERVER, 'REQUEST_TIME'),
                "requestTimeFloat" => array_getValue($_SERVER, 'REQUEST_TIME_FLOAT'),
                "queryString" => array_getValue($_SERVER, 'QUERY_STRING'),
                "documentRoot" => array_getValue($_SERVER, 'DOCUMENT_ROOT'),
                "httpAccept" => array_getValue($_SERVER, 'HTTP_ACCEPT'),
                "httpAcceptCharset" => array_getValue($_SERVER, 'HTTP_ACCEPT_CHARSET'),
                "httpAcceptEncoding" => array_getValue($_SERVER, 'HTTP_ACCEPT_ENCODING'),
                "httpAcceptLanguage" => array_getValue($_SERVER, 'HTTP_ACCEPT_LANGUAGE'),
                "htttpConnection" => array_getValue($_SERVER, 'HTTP_CONNECTION'),
                "httpHost" => array_getValue($_SERVER, 'HTTP_HOST'),
                "httpReferer" => array_getValue($_SERVER, 'HTTP_REFERER'),
                "https" => array_getValue($_SERVER, 'HTTPS'),
                "redirectRemoteUser" => array_getValue($_SERVER, 'REDIRECT_REMOTE_USER'),
                "scriptFilename" => array_getValue($_SERVER, 'SCRIPT_FILENAME'),
                "serverAdmin" => array_getValue($_SERVER, 'SERVER_ADMIN'),
                "serverPort" => array_getValue($_SERVER, 'SERVER_PORT'),
                "serversignature" => array_getValue($_SERVER, 'SERVER_SIGNATURE'),
                "pathTranslated" => array_getValue($_SERVER, 'PATH_TRANSLATED'),
                "scriptName" => array_getValue($_SERVER, 'SCRIPT_NAME'),
                "requestUri" => array_getValue($_SERVER, 'REQUEST_URI'),
                "phpAuthDigest" => array_getValue($_SERVER, 'PHP_AUTH_DIGEST'),
                "phpAuthUser" => array_getValue($_SERVER, 'PHP_AUTH_USER'),
                "phpAuthPassword" => array_getValue($_SERVER, 'PHP_AUTH_PW'),
                "authType" => array_getValue($_SERVER, 'AUTH_TYPE'),
                "pathInfo" => array_getValue($_SERVER, 'PATH_INFO'),
                "origPathInfo" => array_getValue($_SERVER, 'ORIG_PATH_INFO')
            ));

            return $myReturn;
        }

        static function get_model(string $class) {
            
            $myReturn;

            if (\Http::isUriRequest()) { $myReturn = \Http::fromUri($class); } 
            else if (\Http::isFormRequest()) { $myReturn = \Http::fromBody($class); }
            else { $myReturn = \Http::fromJson($class); }

            return $myReturn;
        }

        static function register(): void {

            $cxn = null;

            try {

                \Http::responseDefaultHeaders("GET,POST");

                if (\Http::isActionRequest()) {

                    $myAccount;

                    if (\Http::isUriRequest()) { $myAccount = \Http::fromUri(\AccountDocument::class); }
                    else if (\Http::isFormRequest()) { $myAccount = \Http::fromForm(\AccountDocument::class); }
                    else { $myAccount = \Http::fromJson(\AccountDocument::class); }

                    $context;

                    if ($myAccount->id) {
                        $context = StandardData::get_authorizationParameters("sx.account", 0);
                    }
                    else {
                        $context = StandardData::get_signInModel();

                        $context->username = $myAccount->code;
                        $context->password = $myAccount->passwordNew;
                    }

                    $myReturn = \Service\StandardData::register($context, $myAccount, $cxn);

                    echo json_encode($myReturn);
                }
            }
            catch(\Throwable | \Exception | \Error $ex) {
                \Http::responseBadRequest($ex);
                if ($cxn) { $cxn->close(); }
            }
        }

        static function signIn(): void {

            $cxn = null;

            try {
                \Http::responseDefaultHeaders("GET,POST");

                if (\Http::isActionRequest()) {

                    $myParameters = StandardData::get_signInModel();

                    echo json_encode(\Service\StandardData::signIn($myParameters, $cxn));
                }
            }
            catch(\Throwable | \Exception | \Error $ex) {
                \Http::responseBadRequest($ex);
                
                if ($cxn) { $cxn->close(); }
            }
        }
        
        static function signOut() : void {

            $cxn = null;

            try {
                \Http::responseDefaultHeaders("GET,POST");

                if (\Http::isActionRequest()) {

                    $myParameters = StandardData::get_authorizationParameters("application", 1);

                    \Service\StandardData::signOut($myParameters, $cxn);

                    echo json_encode($myParameters);
                }
            }
            catch(\Throwable | \Exception | \Error $ex) {
                \Http::responseBadRequest($ex);
                
                if ($cxn) { $cxn->close(); }
            }
        }

        static function select(string $tableName, string $context = null, string $parametersClass = \Model\StandardSelectParameters::class, $parametersCallback = null, $resultCallback = null): void {

            $cxn = null;

            try
            {
                \Http::responseDefaultHeaders("GET,POST");

                if (\Http::isActionRequest()) {

                    $myParameters = null;

                    if (\Http::isUriRequest()) { $myParameters = \Http::fromUri($parametersClass); }
                    else if (\Http::isFormRequest()) { $myParameters = \Http::fromBody($parametersClass); }
                    else { $myParameters = \Http::fromJson($parametersClass); }

                    if ($parametersCallback) { $parametersCallback($myParameters); }

                    \Http::responseOk(\Service\StandardData::select(StandardData::get_authorizationParameters($context, 1), $tableName, $myParameters, $cxn, $resultCallback)[0]);
                }
            }
            catch(\Throwable | \Exception | \Error $ex) {
                \Http::responseBadRequest($ex);
                if ($cxn) { $cxn->close(); }
            }
        }

        static function unique(string $tableName, string $context = null, string $parametersClass = \Model\StandardUniqueParameters::class, $parametersCallback = null, $resultCallback = null): void {

            $cxn = null;

            try
            {
                \Http::responseDefaultHeaders("GET,POST"); 

                if (\Http::isActionRequest()) { 

                    $myParameters;

                    if (\Http::isUriRequest()) { $myParameters = \Http::fromUri($parametersClass); } 
                    else if (\Http::isFormRequest()) { $myParameters = \Http::fromBody($parametersClass); }
                    else { $myParameters = \Http::fromJson($parametersClass); }

                    if ($parametersCallback) { $parametersCallback($myParameters); }

                    $mySet = \Service\StandardData::unique(StandardData::get_authorizationParameters($context, 1), $tableName, $myParameters, $cxn, $resultCallback);

                    \Http::responseOk(count($mySet[0]) == 0 ? null : $mySet[0][0]); 
                }
            }
            catch(\Throwable | \Exception | \Error $ex) {
                \Http::responseBadRequest($ex);
                if ($cxn) { $cxn->close(); }
            }
        }

        static function document(string $tableName, string $context = null, string $parametersClass = \Model\StandardUniqueParameters::class, array $tables = ["header"], $parametersCallback = null, $resultCallback = null): void {

            $cxn = null;

            try
            {
                \Http::responseDefaultHeaders("GET,POST");

                if (\Http::isActionRequest()) {

                    $myParameters;

                    if (\Http::isUriRequest()) { $myParameters = \Http::fromUri($parametersClass); } 
                    else if (\Http::isFormRequest()) { $myParameters = \Http::fromBody($parametersClass); }
                    else { $myParameters = \Http::fromJson($parametersClass); }

                    if ($parametersCallback) { $parametersCallback($myParameters); }

                    $mySet = \Service\StandardData::document(StandardData::get_authorizationParameters($context, 1), $tableName, $myParameters, $cxn, $resultCallback);

                    if (count($mySet[0]) == 0) {
                        echo "null";
                    }
                    else {
                        $myReturn = $mySet[0][0];

                        for($myIndex = 1; $myIndex < count($mySet); $myIndex++) {
                            $myReturn[$tables[$myIndex] ?? "table$myIndex"] = $mySet[$myIndex];
                        } 

                        \Http::responseOk($myReturn);
                    }
                }
            }
            catch(\Throwable | \Exception | \Error $ex) {
                \Http::responseBadRequest($ex);
                if ($cxn) { $cxn->close(); }
            }
        }

        static function save(string $tableName, string $context = null, string $parametersClass, array $tables = ["header"], $modelCallback = null, $resultCallback = null): void {

            $cxn = null;

            try
            {
                \Http::responseDefaultHeaders("GET,POST,PUT");

                if (\Http::isActionRequest()) {

                    $myParameters;

                    if (\Http::isUriRequest()) { $myParameters = \Http::fromUri($parametersClass); } 
                    else if (\Http::isFormRequest()) { $myParameters = \Http::fromBody($parametersClass); }
                    else { $myParameters = \Http::fromJson($parametersClass); }

                    if ($modelCallback) { $modelCallback($myParameters); }

                    \Service\StandardData::save(StandardData::get_authorizationParameters($context, 2), $tableName, $myParameters, $cxn, $resultCallback);

                    \Http::responseOk($myParameters);
                }
            }
            catch(\Throwable | \Exception | \Error $ex) {
                \Http::responseBadRequest($ex);
                if ($cxn) { $cxn->close(); }
            }
        }

        static function delete(string $tableName, string $context = null, string $parametersClass = \Model\StandardDeleteParameters::class, array $tables = ["header"], $parametersCallback = null, $resultCallback = null): void {

            $cxn = null;

            try
            {
                \Http::responseDefaultHeaders("POST,DELETE");

                if (\Http::isActionRequest()) {

                    $myParameters;

                    if (\Http::isUriRequest()) { $myParameters = \Http::fromUri($parametersClass); } 
                    else if (\Http::isFormRequest()) { $myParameters = \Http::fromBody($parametersClass); }
                    else { $myParameters = \Http::fromJson($parametersClass); }

                    if ($parametersCallback) { $parametersCallback($myParameters); }

                    $mySet = \Service\StandardData::delete(StandardData::get_authorizationParameters($context, 1), $tableName, $myParameters, $cxn, $resultCallback);

                    $myReturn = $mySet[0][0];

                    for($myIndex = 1; $myIndex < count($mySet); $myIndex++) {
                        $myReturn[$tables[$myIndex] ?? "table$myIndex"] = $mySet[$myIndex];
                    } 

                    \Http::responseOk($myReturn);
                }
            }
            catch(\Throwable | \Exception | \Error $ex) {
                \Http::responseBadRequest($ex);
                if ($cxn) { $cxn->close(); }
            }
        }
    }
}
?>